/* Copyright (c) 2009, 2010, Oracle and/or its affiliates. 
All rights reserved. */

/*

   NAME
     cdemoclid.c - OCI sample program to set/retrieve client identifier

   DESCRIPTION
     This program illustrates how client identifier can be set and retrieved
     using OCI_ATTR_CLIENT_IDENTIFIER attribute

     How to Compile 
          $make -f demo_rdbms.mk build EXE=cdemoclid OBJS=cdemoclid.o
          
     How to Run 
          Usage    : $./cdemoclid <username>/<password>@<dbname>
          Example  : $./cdemoclid scott/tiger@inst1
   
   MODIFIED   (MM/DD/YY)
   ssonawan    05/29/09 - Bug-8559128 : Creation

*/

#ifndef CDEMOCLID_ORACLE
# include <cdemoclid.h>
#endif

int main(argc, argv)
int argc;
char *argv[];
{
  OCISession *session = (OCISession *) 0;
  OCIServer *srvhp;
  OCISvcCtx *svchp;
 
  OCIStmt   *stmthp_ci;
  OCIDefine *defnp_ci = (OCIDefine *) 0;
  char       ci[45];
  short      status;
  char       username[30];
  char       password[30];
  char       dbname  [30];

  if (argc < 2)
  {
    printf("Usage   : $%s <username>/<password>@<dbname>\n", argv[0]);
    printf("Example : $%s scott/tiger@inst1\n", argv[0]);
    return;
  }  
  
  parse_connect_string(argv[1],username, password, dbname);
  
  /* Initialization */  
  (void) OCIInitialize((ub4) OCI_DEFAULT, (dvoid *)0,
                       (dvoid * (*)(dvoid *, size_t)) 0,
                       (dvoid * (*)(dvoid *, dvoid *, size_t))0,
                       (void (*)(dvoid *, dvoid *)) 0 );
  (void) OCIEnvInit((OCIEnv **) &envhp, OCI_DEFAULT, (size_t) 0, 
                    (dvoid **) 0 );
  (void) OCIHandleAlloc((dvoid *) envhp, (dvoid **) &errhp, OCI_HTYPE_ERROR, 
                        (size_t) 0, (dvoid **) 0);

  
  /* Server contexts */
  (void) OCIHandleAlloc((dvoid *) envhp, (dvoid **) &srvhp, OCI_HTYPE_SERVER,
                        (size_t) 0, (dvoid **) 0);
  (void) OCIHandleAlloc((dvoid *) envhp, (dvoid **) &svchp, OCI_HTYPE_SVCCTX,
                        (size_t) 0, (dvoid **) 0);

  checkerr(errhp,  __LINE__, OCIServerAttach(srvhp, errhp, (text *)dbname,
                                  (sb4)strlen(dbname), 0));

  /* Set attribute server context in the service context */
  checkerr(errhp,  __LINE__, OCIAttrSet((dvoid *)svchp, OCI_HTYPE_SVCCTX,
                             (dvoid *)srvhp, (ub4) 0, OCI_ATTR_SERVER,
                             (OCIError *)errhp));

  (void) OCIHandleAlloc((dvoid *) envhp, (dvoid **)&session, 
                        (ub4) OCI_HTYPE_SESSION, (size_t) 0, (dvoid **) 0);

  /* Set user Name and PAssword */
  checkerr(errhp,  __LINE__, OCIAttrSet((dvoid *) session, (ub4) OCI_HTYPE_SESSION,
                             (dvoid *) username, (ub4) strlen((char *)username),
                             (ub4) OCI_ATTR_USERNAME, errhp));
  checkerr(errhp,  __LINE__, OCIAttrSet((dvoid *) session, (ub4) OCI_HTYPE_SESSION,
                             (dvoid *) password, (ub4) strlen((char *)password),
                             (ub4) OCI_ATTR_PASSWORD, errhp));

  /* Start Session */
  checkerr(errhp,  __LINE__, OCISessionBegin(svchp,  errhp, session,
                             OCI_CRED_RDBMS, (ub4) OCI_DEFAULT));

  checkerr(errhp,  __LINE__, OCIAttrSet((dvoid *) svchp, (ub4) OCI_HTYPE_SVCCTX,
                             (dvoid *) session, (ub4) 0,
                             (ub4) OCI_ATTR_SESSION, errhp));

  /* Set the Client identifier to 'Client-ID1' */
  checkerr(errhp,  __LINE__, OCIAttrSet(session, OCI_HTYPE_SESSION,
                             (dvoid *)"Client-ID1", (ub4)strlen("Client-ID1"),
                             OCI_ATTR_CLIENT_IDENTIFIER, (OCIError *) errhp));

  /* Check the value of Client identifier */
  (void) OCIHandleAlloc((dvoid *) envhp, (dvoid **) &stmthp_ci,
                        OCI_HTYPE_STMT, (size_t) 0, (dvoid **) 0);
  checkerr(errhp,  __LINE__, OCIStmtPrepare(stmthp_ci, errhp, selci,
                             (ub4) strlen((char *)selci),
                             (ub4) OCI_NTV_SYNTAX, (ub4) OCI_DEFAULT));
  checkerr(errhp,  __LINE__, OCIDefineByPos(stmthp_ci, &defnp_ci, errhp, 1,
                             (dvoid *) ci, 40, SQLT_STR,
                             (dvoid *) 0, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT));
  checkerr(errhp,  __LINE__, (status = OCIStmtExecute(svchp, stmthp_ci, errhp,
                                  (ub4) 1, (ub4) 0, (CONST OCISnapshot *) NULL,
                                  (OCISnapshot *) NULL, OCI_DEFAULT)));
  
  if (status != OCI_SUCCESS)
    printf ("ERROR in session setting clientid\n");
  else
    printf ("SUCCESS in setting clientid to %s\n", ci);
}

void parse_connect_string(char* connect_str, char* username,
                           char* password,    char* dbname)
{
  char* ptr = username;
  
  username[0] = '\0';
  password[0] = '\0';
  dbname[0] = '\0';

  while (*connect_str) 
  {
    if (*connect_str == '/')
    {
      *ptr = '\0';
      ptr  = password;
      connect_str++;
      continue;
    }
    if (*connect_str == '@')
    {
      *ptr = '\0';
      ptr = dbname;
      connect_str++;
      continue;
    }

    *ptr = *connect_str;
    ptr++;
    connect_str++;
  }
  *ptr = '\0';
}

void report_error(OCIError *errhp)
{
  text  msgbuf[512];
  sb4   errcode = 0;

  memset((void *) msgbuf, (int)'\0', (size_t)512);

  OCIErrorGet((dvoid *) errhp, (ub4) 1, (text *) NULL, &errcode,
                       msgbuf, (ub4) sizeof(msgbuf), (ub4) OCI_HTYPE_ERROR);

  printf("ERROR CODE = %d\n", errcode);
  printf("%.*s\n", 512, msgbuf);
  exit(2);
}

void checkerr(OCIError *errhp, int lineno, sword status)
{
  switch (status)
  {
  case OCI_SUCCESS: 
    break;
  case OCI_SUCCESS_WITH_INFO:
    printf("status = OCI_SUCCESS_WITH_INFO\n");
    printf("at line number : %d\n", lineno);
    report_error(errhp);
    break;
  case OCI_NEED_DATA:
    printf("status = OCI_NEED_DATA\n");
    break;
  case OCI_NO_DATA:
    printf("status = OCI_NO_DATA\n");
    break;
  case OCI_ERROR:
    printf("status = OCI_ERROR\n");
    printf("at line number : %d\n", lineno);
    report_error(errhp);
    break;
  case OCI_INVALID_HANDLE:
    printf("status = OCI_INVALID_HANDLE\n");
    break;
  case OCI_STILL_EXECUTING:
    printf("status = OCI_STILL_EXECUTE\n");
    break;
  case OCI_CONTINUE:
    printf("status = OCI_CONTINUE\n");
    break;
  default:                                       /* report the default error */
    printf("at line number : %d\n", lineno);
    report_error(errhp);
    break;
  }
}

/* end of file cdemoclid.c */
